//*****************************************************************************
//
//  Sample Program for Sytem Time
//
//  Target Machine : CPT-711
//
//  Function:
//  int set_time(char *new_time) : Set new date and itme to the calendar chip.
//  int get_time(char *cur_time) : Get current date and time.
//  int DayOfWeek(void)          : Get the day of the week information.
//
//       YYYYMMDDhhmmss : year(4)month(2)day(2)hour(2)minute(2)second(2)
//
//  SYNTECH INFORMATION CO., LTD.
//
//*****************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void GetKeyData (int x, int y, int len, char *str);

//-------------------------------------------------------------------------//
void main (void)
    {
    int  iday,ibeep[4] = {20,10, 0, 0};
    char sbuf[15],stime[15];

    clr_scr();
    dis_alpha();

    gotoxy (4, 0);
    puts ("CALENDAR TEST");

    //********** set_time **********

    gotoxy (2, 2);
    puts ("DATE(YYYYMMDD)");
    gotoxy (6, 3);
    puts (":");

    sbuf[0] = 0;
    GetKeyData (7, 3, 8, sbuf);
    strncpy (stime, sbuf, 8);

    gotoxy (2, 5);
    puts ("TIME(HHMMSS)");
    gotoxy (6, 6);
    puts (":");

    sbuf[0] = 0;
    GetKeyData (7, 6, 6, sbuf);
    strncpy (stime+8, sbuf, 6);

    set_time (stime);
    on_beeper (ibeep);

    //********** get_time **********

    clr_scr();
    gotoxy (4, 0);
    puts ("CALENDAR TEST");

    get_time (stime);

    sbuf[ 0] = stime[ 0];
    sbuf[ 1] = stime[ 1];
    sbuf[ 2] = stime[ 2];
    sbuf[ 3] = stime[ 3];
    sbuf[ 4] = '/';
    sbuf[ 5] = stime[ 4];
    sbuf[ 6] = stime[ 5];
    sbuf[ 7] = '/';
    sbuf[ 8] = stime[ 6];
    sbuf[ 9] = stime[ 7];
    sbuf[10] = 0;

    gotoxy (3, 2);
    printf ("DATE:%s", sbuf);

    sbuf[0] = stime[ 8];
    sbuf[1] = stime[ 9];
    sbuf[2] = ':';
    sbuf[3] = stime[10];
    sbuf[4] = stime[11];
    sbuf[5] = ':';
    sbuf[6] = stime[12];
    sbuf[7] = stime[13];
    sbuf[8] = 0;

    gotoxy (3, 4);
    printf ("TIME:%s", sbuf);

    //********** DayOfWeek **********

    iday = DayOfWeek();

    gotoxy (1, 6);
    puts ("TODAY IS ");

    switch (iday)
        {
        case 1:
             puts ("MONDAY.");
             break;

        case 2:
             puts ("TUESDAY.");
             break;

        case 3:
             puts ("WEDNESDAY.");
             break;

        case 4:
             puts ("THURSDAY.");
             break;

        case 5:
             puts ("FRIDAY.");
             break;

        case 6:
             puts ("SATURDAY.");
             break;

        case 7:
             puts ("SUNDAY.");
             break;
        }

    while (getchar() != KEY_ESC);
    }


//************************************************
// GetKeyData() : Get keyboard data.
//************************************************

void GetKeyData (int x, int y, int len, char *str)
    {
    int  i, xpos, ypos, pos;
    char ckey, skeydata[50];

    clr_kb ();
    SetCursor (1);

    pos = 0;
    skeydata[0] = 0;

    xpos = x;
    ypos = y;
    gotoxy (xpos, ypos);

    while(1)
        {
        if (ckey = getchar())
            {
            switch (ckey)
                {
                case KEY_BS:
                     if (pos == 0)  break;

                     gotoxy (--xpos, ypos);
                     putchar (0x20);

                     skeydata [--pos] = 0;
                     gotoxy (xpos, ypos);
                     break;

                case KEY_CR:
                     if (pos < len)  break;

                     skeydata [pos] = 0;
                     strcpy (str, skeydata);
                     SetCursor (0);
                     return;

                default:
                     if (ckey < '0' || ckey > '9')  break;

                     gotoxy (xpos, ypos);
                     putchar (ckey);

                     skeydata [pos++] = ckey;

                     gotoxy (++xpos, ypos);

                     if (pos >= len)
                         {
                         skeydata [len] = 0;
                         strcpy (str, skeydata);
                         SetCursor (0);
                         return;
                         }
                     break;
                }
            }
        }
    }
//-------------------------------------------------------------------------//
